/* ------------------------------------------------------------------
 *
 * tin2rad.c
 *
 * copyright 1998 Mark J. Stock
 *
 * v0.0 1998-08-17	initial version
 *
 * The object of tin2rad is to be a tool for converting heightfield
 * data, in the form of a scape-produced .TIN file, to a radiance-
 * readable format.
 *
 * ------------------------------------------------------------------ */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

int inheight, inwidth;

main(int argc, char *argv[]) {

   /* initialize variables */
   int i, ct;
   char progname[80];			/* name of executable */
   char infile[80];			/* name of the input TIN triangle mesh file */
   char outfile[80];			/* name of the output Radiance file */
   FILE *ifp;				/* .tin file pointer, read in */
   FILE *ofp;				/* .rad file pointer, write out */
   char sbuf[120];			/* input buffer */
   char polytype;			/* polygon type in tin file */
   char data[100];			/* triangle node data */

   /*
    * Parse the command-line options
    */
   (void) strcpy(progname,argv[0]);
   if (argc < 5) (void) Usage(progname,0);
   for (i=1; i<argc; i++) {
      if (strncmp(argv[i], "-help", 2) == 0)
         (void) Usage(progname,0);
      else if (strncmp(argv[i], "-infile", 2) == 0)
         (void) strcpy(infile,argv[++i]); 
      else if (strncmp(argv[i], "-outfile", 2) == 0)
         (void) strcpy(outfile,argv[++i]); 
      else
         (void) Usage(progname,0);
   }


   /*
    * Read in/Write out
    */

   /* open the .tin file for reading */
   ifp = fopen(infile,"r");
   if (ifp==NULL) {
      fprintf(stderr,"Could not open input file %s\n",infile);
      exit(0);
   }
   fprintf(stderr,"Opening file %s for reading\n",infile);
   fflush(stderr);

   /* open the .rad file for writing */
   ofp = fopen(outfile,"w");
   if (ofp==NULL) {
      fprintf(stderr,"Could not open output Radiance file %s\n",outfile);
      exit(0);
   }
   fprintf(stderr,"Opening file %s for writing\n",outfile);
   fflush(stderr);
   fprintf(ofp,"# Radiance scene file of terrain polygons\n\n");
   fflush(ofp);

   ct = 0;
   (void) fprintf(stderr,"Converting polygons.\n");
   /* while ((fscanf(ifp,"%s",sbuf) != EOF) && sbuf[0] != '#') { */
   while ((fgets(sbuf,119,ifp) != NULL) && sbuf[0] != '#') {

      /* (void) fprintf(stderr,"   poly %d, (%s)\n",ct,sbuf); */
      fflush(stderr);
      if (sbuf[0] == 't') {
         sbuf[0] = ' ';
         /* (void) sscanf(sbuf,"%c %s",polytype,data); */
         fprintf(ofp,"ground_mat polygon t%d\n0 0 9%s",ct,sbuf);
         ct++;
      }
   }

   fclose(ifp);
   fclose(ofp);

   /*
    * Write output statistics and quit
    */
   (void) fprintf(stdout,"Wrote %d polygons.\n",ct);
}


/*
 * This function writes basic usage information to stderr,
 * and then quits. Too bad.
 */
int Usage(char progname[80],int status) {

   /* Usage for tin2rad */
   static char **cpp, *help_message[] =
   {
       "where options include:",
       "  -help          writes this help information",
       "  -in name       name of input .tin file",
       "  -out name      name of output .rad file",
       " ",
       "Options may be abbreviated to an unambiguous length.",
       NULL
   };

   fprintf(stderr, "usage:\n  %s [-options ...]\n\n", progname);
   for (cpp = help_message; *cpp; cpp++)
      fprintf(stderr, "%s\n", *cpp);
   exit(status);
   return(0);
}

