/***********************************************************
 *
 *  pgm2stm.c - a 16-bit grayscale image conversion program
 *
 *  Mark J. Stock, August 28, 1998, version 0.1
 *
 ***********************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "const.h"

int inheight, inwidth;		/* size of the input file */

void main(int argc,char **argv) {

   int i,j;
   char infile[80];
   char outfile[80];
   char progname[80];
   unsigned short int a[MAX_SIZE][MAX_SIZE];
   unsigned short int b[MAX_SIZE][MAX_SIZE];
   int min_val = 0;

   /* function declarations */
   int write_stm(char [80],unsigned short int [MAX_SIZE][MAX_SIZE],int,int);

   inheight = 256;		/* default values */
   inwidth = 256;

   /*
    * Parse command-line args
    */
   (void) strcpy(progname,argv[0]);
   if (argc < 5) (void) Usage(progname,0);
   for (i=1; i<argc; i++) {
      if (strncmp(argv[i], "-help", 2) == 0)
         (void) Usage(progname,0);
      else if (strncmp(argv[i], "-infile", 2) == 0)
         (void) strcpy(infile,argv[++i]); 
      else if (strncmp(argv[i], "-outfile", 2) == 0)
         (void) strcpy(outfile,argv[++i]); 
      else
         (void) Usage(progname,0);
   }


   /* read in the input file */
   (void)read_pgm_ushort(infile,a);

   /* find the minimum value of the array, if it is negative, shift all
    * values toward positive */
   for (i=0; i<inheight; i++) {
      for (j=0; j<inwidth; j++) {
         if (a[i][j] < min_val) min_val = a[i][j];
      }
   }
   fprintf(stderr,"Minimum value of input is %d",min_val);
   if (min_val < 0) {
      fprintf(stderr,", shifting all values up %d\n",-min_val);
      for (i=0; i<inheight; i++) {
         for (j=0; j<inwidth; j++) {
            b[i][j] = (unsigned short int)(a[i][j] - min_val);
         }
      }
   } else {
      fprintf(stderr,"\n");
      for (i=0; i<inheight; i++) {
         for (j=0; j<inwidth; j++) {
            b[i][j] = (unsigned short int)a[i][j];
         }
      }
   }

   /* write out a frame at the end */
   (void) write_stm(outfile,b,inheight,inwidth);

}


/*
 * Code for writing an STM file
 */
int write_stm(char filename[80],unsigned short int a[MAX_SIZE][MAX_SIZE],
              int height,int width) {

   int i,j;
   FILE *fp;
   unsigned short int twob;
   int xloc, yloc;

   /* open the .stm file for writing */
   fp = fopen(filename,"w");
   if (fp==NULL) {
      fprintf(stderr,"Could not open output file %s\n",filename);
      exit(0);
   }

   /* write a header */
   fprintf(fp,"STM %d %d %c%c%c%c\n", width, height, 4, 3, 2, 1);

   /* write each data point as an int to the file */
   for (i=0; i<height; i++) {
      for (j=0; j<width; j++) {
         twob = (unsigned short int)a[i][j];
         (void) fwrite(&twob,sizeof(unsigned short int),1,fp);
      }
   }

   /* close the file before returning to main */
   (void) fclose(fp);

   /* everything went OK, return zero */
   return(0);
}


/*
 * This function writes basic usage information to stderr,
 * and then quits. Too bad.
 */
int Usage(char progname[80],int status) {

   /* Usage for hfcolor */
   static char **cpp, *help_message[] =
   {
       "where options include:",
       "  -help          writes this help information",
       "  -in name       name of input PGM file, binary or raw",
       "  -out name      name of output STM file, binary",
       " ",
       "Options may be abbreviated to an unambiguous length.",
       NULL
   };

   fprintf(stderr, "usage:\n  %s [-options ...]\n\n", progname);
   for (cpp = help_message; *cpp; cpp++)
      fprintf(stderr, "%s\n", *cpp);
   exit(status);
   return(0);
}

